#include "../include/typedefs.h"

// Example code from MISRA C:2012 begin
static int8_t count;      /* Non-compliant - "count" has internal
                           * linkage but clashes with other
                           * identifiers of the same name            */

static void foo ( void )  /* Non-compliant - "foo" has internal
                           * linkage but clashes with a function of
                           * the same name                           */
{
  int32_t index;          /* Compliant - both "index" and "nbytes"   */
  int16_t nbytes;         /* are not unique but have no linkage      */
}

void bar2 ( void )
{
  static uint8_t nbytes;  /* Compliant - "nbytes" is not unique but
                           * has no linkage and the storage class is
                           * irrelevant                              */
}
// Example code from MISRA C:2012 end
